package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeGlobalClustersRequest(globalClusterIdentifier: scala.Option[primitives.GlobalClusterIdentifier] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersRequest = {
    import DescribeGlobalClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersRequest.builder().optionallyWith(globalClusterIdentifier.map(value => value: java.lang.String))(_.globalClusterIdentifier).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
  }
  def asReadOnly: DescribeGlobalClustersRequest.ReadOnly = DescribeGlobalClustersRequest.wrap(buildAwsValue())
}
object DescribeGlobalClustersRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeGlobalClustersRequest = DescribeGlobalClustersRequest(globalClusterIdentifierValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }), maxRecordsValue.map(value => value), markerValue.map(value => value))
    def globalClusterIdentifierValue: scala.Option[primitives.GlobalClusterIdentifier]
    def filtersValue: scala.Option[List[Filter.ReadOnly]]
    def maxRecordsValue: scala.Option[primitives.IntegerOptional]
    def markerValue: scala.Option[String]
    def globalClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GlobalClusterIdentifier] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusterIdentifier", globalClusterIdentifierValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersRequest) extends DescribeGlobalClustersRequest.ReadOnly {
    override def globalClusterIdentifierValue: scala.Option[primitives.GlobalClusterIdentifier] = scala.Option(impl.globalClusterIdentifier()).map(value => value: primitives.GlobalClusterIdentifier)
    override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      Filter.wrap(item)
    }.toList)
    override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersRequest): ReadOnly = new Wrapper(impl)
}