package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeGlobalClustersResponse(marker: scala.Option[String] = None, globalClusters: scala.Option[Iterable[GlobalCluster]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersResponse = {
    import DescribeGlobalClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(globalClusters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.globalClusters).build()
  }
  def asReadOnly: DescribeGlobalClustersResponse.ReadOnly = DescribeGlobalClustersResponse.wrap(buildAwsValue())
}
object DescribeGlobalClustersResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeGlobalClustersResponse = DescribeGlobalClustersResponse(markerValue.map(value => value), globalClustersValue.map(value => value.map { item => 
      item.editable
    }))
    def markerValue: scala.Option[String]
    def globalClustersValue: scala.Option[List[GlobalCluster.ReadOnly]]
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    def globalClusters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[GlobalCluster.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusters", globalClustersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersResponse) extends DescribeGlobalClustersResponse.ReadOnly {
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    override def globalClustersValue: scala.Option[List[GlobalCluster.ReadOnly]] = scala.Option(impl.globalClusters()).map(value => value.asScala.map { item => 
      GlobalCluster.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersResponse): ReadOnly = new Wrapper(impl)
}