package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeOrderableDbInstanceOptionsRequest(engine: String, engineVersion: scala.Option[String] = None, dbInstanceClass: scala.Option[String] = None, licenseModel: scala.Option[String] = None, vpc: scala.Option[primitives.BooleanOptional] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest = {
    import DescribeOrderableDbInstanceOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest.builder().engine(engine: java.lang.String).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(_.dbInstanceClass).optionallyWith(licenseModel.map(value => value: java.lang.String))(_.licenseModel).optionallyWith(vpc.map(value => value: java.lang.Boolean))(_.vpc).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
  }
  def asReadOnly: DescribeOrderableDbInstanceOptionsRequest.ReadOnly = DescribeOrderableDbInstanceOptionsRequest.wrap(buildAwsValue())
}
object DescribeOrderableDbInstanceOptionsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeOrderableDbInstanceOptionsRequest = DescribeOrderableDbInstanceOptionsRequest(engineValue, engineVersionValue.map(value => value), dbInstanceClassValue.map(value => value), licenseModelValue.map(value => value), vpcValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }), maxRecordsValue.map(value => value), markerValue.map(value => value))
    def engineValue: String
    def engineVersionValue: scala.Option[String]
    def dbInstanceClassValue: scala.Option[String]
    def licenseModelValue: scala.Option[String]
    def vpcValue: scala.Option[primitives.BooleanOptional]
    def filtersValue: scala.Option[List[Filter.ReadOnly]]
    def maxRecordsValue: scala.Option[primitives.IntegerOptional]
    def markerValue: scala.Option[String]
    def engine: ZIO[Any, Nothing, String] = ZIO.succeed(engineValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def dbInstanceClass: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClassValue)
    def licenseModel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseModel", licenseModelValue)
    def vpc: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpc", vpcValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest) extends DescribeOrderableDbInstanceOptionsRequest.ReadOnly {
    override def engineValue: String = impl.engine(): String
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def dbInstanceClassValue: scala.Option[String] = scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override def licenseModelValue: scala.Option[String] = scala.Option(impl.licenseModel()).map(value => value: String)
    override def vpcValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.vpc()).map(value => value: primitives.BooleanOptional)
    override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      Filter.wrap(item)
    }.toList)
    override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest): ReadOnly = new Wrapper(impl)
}