package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeOrderableDbInstanceOptionsResponse(orderableDBInstanceOptions: scala.Option[Iterable[OrderableDBInstanceOption]] = None, marker: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse = {
    import DescribeOrderableDbInstanceOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse.builder().optionallyWith(orderableDBInstanceOptions.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.orderableDBInstanceOptions).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
  }
  def asReadOnly: DescribeOrderableDbInstanceOptionsResponse.ReadOnly = DescribeOrderableDbInstanceOptionsResponse.wrap(buildAwsValue())
}
object DescribeOrderableDbInstanceOptionsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeOrderableDbInstanceOptionsResponse = DescribeOrderableDbInstanceOptionsResponse(orderableDBInstanceOptionsValue.map(value => value.map { item => 
      item.editable
    }), markerValue.map(value => value))
    def orderableDBInstanceOptionsValue: scala.Option[List[OrderableDBInstanceOption.ReadOnly]]
    def markerValue: scala.Option[String]
    def orderableDBInstanceOptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[OrderableDBInstanceOption.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("orderableDBInstanceOptions", orderableDBInstanceOptionsValue)
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse) extends DescribeOrderableDbInstanceOptionsResponse.ReadOnly {
    override def orderableDBInstanceOptionsValue: scala.Option[List[OrderableDBInstanceOption.ReadOnly]] = scala.Option(impl.orderableDBInstanceOptions()).map(value => value.asScala.map { item => 
      OrderableDBInstanceOption.wrap(item)
    }.toList)
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse): ReadOnly = new Wrapper(impl)
}