package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribePendingMaintenanceActionsRequest(resourceIdentifier: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, marker: scala.Option[String] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest = {
    import DescribePendingMaintenanceActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest.builder().optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(_.resourceIdentifier).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).build()
  }
  def asReadOnly: DescribePendingMaintenanceActionsRequest.ReadOnly = DescribePendingMaintenanceActionsRequest.wrap(buildAwsValue())
}
object DescribePendingMaintenanceActionsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribePendingMaintenanceActionsRequest = DescribePendingMaintenanceActionsRequest(resourceIdentifierValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }), markerValue.map(value => value), maxRecordsValue.map(value => value))
    def resourceIdentifierValue: scala.Option[String]
    def filtersValue: scala.Option[List[Filter.ReadOnly]]
    def markerValue: scala.Option[String]
    def maxRecordsValue: scala.Option[primitives.IntegerOptional]
    def resourceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifierValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest) extends DescribePendingMaintenanceActionsRequest.ReadOnly {
    override def resourceIdentifierValue: scala.Option[String] = scala.Option(impl.resourceIdentifier()).map(value => value: String)
    override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      Filter.wrap(item)
    }.toList)
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest): ReadOnly = new Wrapper(impl)
}