package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Endpoint(address: scala.Option[String] = None, port: scala.Option[primitives.Integer] = None, hostedZoneId: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.Endpoint = {
    import Endpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.Endpoint.builder().optionallyWith(address.map(value => value: java.lang.String))(_.address).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(hostedZoneId.map(value => value: java.lang.String))(_.hostedZoneId).build()
  }
  def asReadOnly: Endpoint.ReadOnly = Endpoint.wrap(buildAwsValue())
}
object Endpoint {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.Endpoint] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Endpoint = Endpoint(addressValue.map(value => value), portValue.map(value => value), hostedZoneIdValue.map(value => value))
    def addressValue: scala.Option[String]
    def portValue: scala.Option[primitives.Integer]
    def hostedZoneIdValue: scala.Option[String]
    def address: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("address", addressValue)
    def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
    def hostedZoneId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hostedZoneId", hostedZoneIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.Endpoint) extends Endpoint.ReadOnly {
    override def addressValue: scala.Option[String] = scala.Option(impl.address()).map(value => value: String)
    override def portValue: scala.Option[primitives.Integer] = scala.Option(impl.port()).map(value => value: primitives.Integer)
    override def hostedZoneIdValue: scala.Option[String] = scala.Option(impl.hostedZoneId()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.Endpoint): ReadOnly = new Wrapper(impl)
}