package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EngineDefaults(dbParameterGroupFamily: scala.Option[String] = None, marker: scala.Option[String] = None, parameters: scala.Option[Iterable[Parameter]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.EngineDefaults = {
    import EngineDefaults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.EngineDefaults.builder().optionallyWith(dbParameterGroupFamily.map(value => value: java.lang.String))(_.dbParameterGroupFamily).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(parameters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.parameters).build()
  }
  def asReadOnly: EngineDefaults.ReadOnly = EngineDefaults.wrap(buildAwsValue())
}
object EngineDefaults {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.EngineDefaults] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EngineDefaults = EngineDefaults(dbParameterGroupFamilyValue.map(value => value), markerValue.map(value => value), parametersValue.map(value => value.map { item => 
      item.editable
    }))
    def dbParameterGroupFamilyValue: scala.Option[String]
    def markerValue: scala.Option[String]
    def parametersValue: scala.Option[List[Parameter.ReadOnly]]
    def dbParameterGroupFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamilyValue)
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    def parameters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Parameter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parameters", parametersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.EngineDefaults) extends EngineDefaults.ReadOnly {
    override def dbParameterGroupFamilyValue: scala.Option[String] = scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    override def parametersValue: scala.Option[List[Parameter.ReadOnly]] = scala.Option(impl.parameters()).map(value => value.asScala.map { item => 
      Parameter.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.EngineDefaults): ReadOnly = new Wrapper(impl)
}