package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Event(sourceIdentifier: scala.Option[String] = None, sourceType: scala.Option[SourceType] = None, message: scala.Option[String] = None, eventCategories: scala.Option[Iterable[String]] = None, date: scala.Option[primitives.TStamp] = None, sourceArn: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.Event.builder().optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(_.sourceIdentifier).optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType).optionallyWith(message.map(value => value: java.lang.String))(_.message).optionallyWith(eventCategories.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.eventCategories).optionallyWith(date.map(value => value: java.time.Instant))(_.date).optionallyWith(sourceArn.map(value => value: java.lang.String))(_.sourceArn).build()
  }
  def asReadOnly: Event.ReadOnly = Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.Event] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Event = Event(sourceIdentifierValue.map(value => value), sourceTypeValue.map(value => value), messageValue.map(value => value), eventCategoriesValue.map(value => value), dateValue.map(value => value), sourceArnValue.map(value => value))
    def sourceIdentifierValue: scala.Option[String]
    def sourceTypeValue: scala.Option[SourceType]
    def messageValue: scala.Option[String]
    def eventCategoriesValue: scala.Option[List[String]]
    def dateValue: scala.Option[primitives.TStamp]
    def sourceArnValue: scala.Option[String]
    def sourceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifierValue)
    def sourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceType", sourceTypeValue)
    def message: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("message", messageValue)
    def eventCategories: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventCategories", eventCategoriesValue)
    def date: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("date", dateValue)
    def sourceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceArn", sourceArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.Event) extends Event.ReadOnly {
    override def sourceIdentifierValue: scala.Option[String] = scala.Option(impl.sourceIdentifier()).map(value => value: String)
    override def sourceTypeValue: scala.Option[SourceType] = scala.Option(impl.sourceType()).map(value => SourceType.wrap(value))
    override def messageValue: scala.Option[String] = scala.Option(impl.message()).map(value => value: String)
    override def eventCategoriesValue: scala.Option[List[String]] = scala.Option(impl.eventCategories()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def dateValue: scala.Option[primitives.TStamp] = scala.Option(impl.date()).map(value => value: primitives.TStamp)
    override def sourceArnValue: scala.Option[String] = scala.Option(impl.sourceArn()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.Event): ReadOnly = new Wrapper(impl)
}