package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EventCategoriesMap(sourceType: scala.Option[String] = None, eventCategories: scala.Option[Iterable[String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.EventCategoriesMap = {
    import EventCategoriesMap.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.EventCategoriesMap.builder().optionallyWith(sourceType.map(value => value: java.lang.String))(_.sourceType).optionallyWith(eventCategories.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.eventCategories).build()
  }
  def asReadOnly: EventCategoriesMap.ReadOnly = EventCategoriesMap.wrap(buildAwsValue())
}
object EventCategoriesMap {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.EventCategoriesMap] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EventCategoriesMap = EventCategoriesMap(sourceTypeValue.map(value => value), eventCategoriesValue.map(value => value))
    def sourceTypeValue: scala.Option[String]
    def eventCategoriesValue: scala.Option[List[String]]
    def sourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceType", sourceTypeValue)
    def eventCategories: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventCategories", eventCategoriesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.EventCategoriesMap) extends EventCategoriesMap.ReadOnly {
    override def sourceTypeValue: scala.Option[String] = scala.Option(impl.sourceType()).map(value => value: String)
    override def eventCategoriesValue: scala.Option[List[String]] = scala.Option(impl.eventCategories()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.EventCategoriesMap): ReadOnly = new Wrapper(impl)
}