package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EventSubscription(customerAwsId: scala.Option[String] = None, custSubscriptionId: scala.Option[String] = None, snsTopicArn: scala.Option[String] = None, status: scala.Option[String] = None, subscriptionCreationTime: scala.Option[String] = None, sourceType: scala.Option[String] = None, sourceIdsList: scala.Option[Iterable[String]] = None, eventCategoriesList: scala.Option[Iterable[String]] = None, enabled: scala.Option[Boolean] = None, eventSubscriptionArn: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.EventSubscription = {
    import EventSubscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.EventSubscription.builder().optionallyWith(customerAwsId.map(value => value: java.lang.String))(_.customerAwsId).optionallyWith(custSubscriptionId.map(value => value: java.lang.String))(_.custSubscriptionId).optionallyWith(snsTopicArn.map(value => value: java.lang.String))(_.snsTopicArn).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(subscriptionCreationTime.map(value => value: java.lang.String))(_.subscriptionCreationTime).optionallyWith(sourceType.map(value => value: java.lang.String))(_.sourceType).optionallyWith(sourceIdsList.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.sourceIdsList).optionallyWith(eventCategoriesList.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.eventCategoriesList).optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled).optionallyWith(eventSubscriptionArn.map(value => value: java.lang.String))(_.eventSubscriptionArn).build()
  }
  def asReadOnly: EventSubscription.ReadOnly = EventSubscription.wrap(buildAwsValue())
}
object EventSubscription {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.EventSubscription] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EventSubscription = EventSubscription(customerAwsIdValue.map(value => value), custSubscriptionIdValue.map(value => value), snsTopicArnValue.map(value => value), statusValue.map(value => value), subscriptionCreationTimeValue.map(value => value), sourceTypeValue.map(value => value), sourceIdsListValue.map(value => value), eventCategoriesListValue.map(value => value), enabledValue.map(value => value), eventSubscriptionArnValue.map(value => value))
    def customerAwsIdValue: scala.Option[String]
    def custSubscriptionIdValue: scala.Option[String]
    def snsTopicArnValue: scala.Option[String]
    def statusValue: scala.Option[String]
    def subscriptionCreationTimeValue: scala.Option[String]
    def sourceTypeValue: scala.Option[String]
    def sourceIdsListValue: scala.Option[List[String]]
    def eventCategoriesListValue: scala.Option[List[String]]
    def enabledValue: scala.Option[Boolean]
    def eventSubscriptionArnValue: scala.Option[String]
    def customerAwsId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAwsId", customerAwsIdValue)
    def custSubscriptionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("custSubscriptionId", custSubscriptionIdValue)
    def snsTopicArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snsTopicArn", snsTopicArnValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def subscriptionCreationTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subscriptionCreationTime", subscriptionCreationTimeValue)
    def sourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceType", sourceTypeValue)
    def sourceIdsList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceIdsList", sourceIdsListValue)
    def eventCategoriesList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventCategoriesList", eventCategoriesListValue)
    def enabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enabled", enabledValue)
    def eventSubscriptionArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventSubscriptionArn", eventSubscriptionArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.EventSubscription) extends EventSubscription.ReadOnly {
    override def customerAwsIdValue: scala.Option[String] = scala.Option(impl.customerAwsId()).map(value => value: String)
    override def custSubscriptionIdValue: scala.Option[String] = scala.Option(impl.custSubscriptionId()).map(value => value: String)
    override def snsTopicArnValue: scala.Option[String] = scala.Option(impl.snsTopicArn()).map(value => value: String)
    override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
    override def subscriptionCreationTimeValue: scala.Option[String] = scala.Option(impl.subscriptionCreationTime()).map(value => value: String)
    override def sourceTypeValue: scala.Option[String] = scala.Option(impl.sourceType()).map(value => value: String)
    override def sourceIdsListValue: scala.Option[List[String]] = scala.Option(impl.sourceIdsList()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def eventCategoriesListValue: scala.Option[List[String]] = scala.Option(impl.eventCategoriesList()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def enabledValue: scala.Option[Boolean] = scala.Option(impl.enabled()).map(value => value: Boolean)
    override def eventSubscriptionArnValue: scala.Option[String] = scala.Option(impl.eventSubscriptionArn()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.EventSubscription): ReadOnly = new Wrapper(impl)
}