package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class FailoverDbClusterRequest(dbClusterIdentifier: scala.Option[String] = None, targetDBInstanceIdentifier: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.FailoverDbClusterRequest = {
    import FailoverDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.FailoverDbClusterRequest.builder().optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(targetDBInstanceIdentifier.map(value => value: java.lang.String))(_.targetDBInstanceIdentifier).build()
  }
  def asReadOnly: FailoverDbClusterRequest.ReadOnly = FailoverDbClusterRequest.wrap(buildAwsValue())
}
object FailoverDbClusterRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.FailoverDbClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: FailoverDbClusterRequest = FailoverDbClusterRequest(dbClusterIdentifierValue.map(value => value), targetDBInstanceIdentifierValue.map(value => value))
    def dbClusterIdentifierValue: scala.Option[String]
    def targetDBInstanceIdentifierValue: scala.Option[String]
    def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
    def targetDBInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetDBInstanceIdentifier", targetDBInstanceIdentifierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.FailoverDbClusterRequest) extends FailoverDbClusterRequest.ReadOnly {
    override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override def targetDBInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.targetDBInstanceIdentifier()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.FailoverDbClusterRequest): ReadOnly = new Wrapper(impl)
}