package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Filter(name: String, values: Iterable[String]) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.Filter.builder().name(name: java.lang.String).values(values.map { item => 
      item: java.lang.String
    }.asJavaCollection).build()
  }
  def asReadOnly: Filter.ReadOnly = Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.Filter] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Filter = Filter(nameValue, valuesValue)
    def nameValue: String
    def valuesValue: List[String]
    def name: ZIO[Any, Nothing, String] = ZIO.succeed(nameValue)
    def values: ZIO[Any, Nothing, List[String]] = ZIO.succeed(valuesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.Filter) extends Filter.ReadOnly {
    override def nameValue: String = impl.name(): String
    override def valuesValue: List[String] = impl.values().asScala.map { item => 
      item: String
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.Filter): ReadOnly = new Wrapper(impl)
}