package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GlobalCluster(globalClusterIdentifier: scala.Option[primitives.GlobalClusterIdentifier] = None, globalClusterResourceId: scala.Option[String] = None, globalClusterArn: scala.Option[String] = None, status: scala.Option[String] = None, engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, databaseName: scala.Option[String] = None, storageEncrypted: scala.Option[primitives.BooleanOptional] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None, globalClusterMembers: scala.Option[Iterable[GlobalClusterMember]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.GlobalCluster = {
    import GlobalCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.GlobalCluster.builder().optionallyWith(globalClusterIdentifier.map(value => value: java.lang.String))(_.globalClusterIdentifier).optionallyWith(globalClusterResourceId.map(value => value: java.lang.String))(_.globalClusterResourceId).optionallyWith(globalClusterArn.map(value => value: java.lang.String))(_.globalClusterArn).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(databaseName.map(value => value: java.lang.String))(_.databaseName).optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(_.storageEncrypted).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).optionallyWith(globalClusterMembers.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.globalClusterMembers).build()
  }
  def asReadOnly: GlobalCluster.ReadOnly = GlobalCluster.wrap(buildAwsValue())
}
object GlobalCluster {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.GlobalCluster] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GlobalCluster = GlobalCluster(globalClusterIdentifierValue.map(value => value), globalClusterResourceIdValue.map(value => value), globalClusterArnValue.map(value => value), statusValue.map(value => value), engineValue.map(value => value), engineVersionValue.map(value => value), databaseNameValue.map(value => value), storageEncryptedValue.map(value => value), deletionProtectionValue.map(value => value), globalClusterMembersValue.map(value => value.map { item => 
      item.editable
    }))
    def globalClusterIdentifierValue: scala.Option[primitives.GlobalClusterIdentifier]
    def globalClusterResourceIdValue: scala.Option[String]
    def globalClusterArnValue: scala.Option[String]
    def statusValue: scala.Option[String]
    def engineValue: scala.Option[String]
    def engineVersionValue: scala.Option[String]
    def databaseNameValue: scala.Option[String]
    def storageEncryptedValue: scala.Option[primitives.BooleanOptional]
    def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
    def globalClusterMembersValue: scala.Option[List[GlobalClusterMember.ReadOnly]]
    def globalClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GlobalClusterIdentifier] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusterIdentifier", globalClusterIdentifierValue)
    def globalClusterResourceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusterResourceId", globalClusterResourceIdValue)
    def globalClusterArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusterArn", globalClusterArnValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def databaseName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("databaseName", databaseNameValue)
    def storageEncrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageEncrypted", storageEncryptedValue)
    def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
    def globalClusterMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[GlobalClusterMember.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusterMembers", globalClusterMembersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.GlobalCluster) extends GlobalCluster.ReadOnly {
    override def globalClusterIdentifierValue: scala.Option[primitives.GlobalClusterIdentifier] = scala.Option(impl.globalClusterIdentifier()).map(value => value: primitives.GlobalClusterIdentifier)
    override def globalClusterResourceIdValue: scala.Option[String] = scala.Option(impl.globalClusterResourceId()).map(value => value: String)
    override def globalClusterArnValue: scala.Option[String] = scala.Option(impl.globalClusterArn()).map(value => value: String)
    override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
    override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def databaseNameValue: scala.Option[String] = scala.Option(impl.databaseName()).map(value => value: String)
    override def storageEncryptedValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.storageEncrypted()).map(value => value: primitives.BooleanOptional)
    override def deletionProtectionValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deletionProtection()).map(value => value: primitives.BooleanOptional)
    override def globalClusterMembersValue: scala.Option[List[GlobalClusterMember.ReadOnly]] = scala.Option(impl.globalClusterMembers()).map(value => value.asScala.map { item => 
      GlobalClusterMember.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.GlobalCluster): ReadOnly = new Wrapper(impl)
}