package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GlobalClusterMember(dbClusterArn: scala.Option[String] = None, readers: scala.Option[Iterable[String]] = None, isWriter: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.GlobalClusterMember = {
    import GlobalClusterMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.GlobalClusterMember.builder().optionallyWith(dbClusterArn.map(value => value: java.lang.String))(_.dbClusterArn).optionallyWith(readers.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.readers).optionallyWith(isWriter.map(value => value: java.lang.Boolean))(_.isWriter).build()
  }
  def asReadOnly: GlobalClusterMember.ReadOnly = GlobalClusterMember.wrap(buildAwsValue())
}
object GlobalClusterMember {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.GlobalClusterMember] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GlobalClusterMember = GlobalClusterMember(dbClusterArnValue.map(value => value), readersValue.map(value => value), isWriterValue.map(value => value))
    def dbClusterArnValue: scala.Option[String]
    def readersValue: scala.Option[List[String]]
    def isWriterValue: scala.Option[Boolean]
    def dbClusterArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterArn", dbClusterArnValue)
    def readers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("readers", readersValue)
    def isWriter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isWriter", isWriterValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.GlobalClusterMember) extends GlobalClusterMember.ReadOnly {
    override def dbClusterArnValue: scala.Option[String] = scala.Option(impl.dbClusterArn()).map(value => value: String)
    override def readersValue: scala.Option[List[String]] = scala.Option(impl.readers()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def isWriterValue: scala.Option[Boolean] = scala.Option(impl.isWriter()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.GlobalClusterMember): ReadOnly = new Wrapper(impl)
}