package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListTagsForResourceRequest(resourceName: String, filters: scala.Option[Iterable[Filter]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest.builder().resourceName(resourceName: java.lang.String).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).build()
  }
  def asReadOnly: ListTagsForResourceRequest.ReadOnly = ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListTagsForResourceRequest = ListTagsForResourceRequest(resourceNameValue, filtersValue.map(value => value.map { item => 
      item.editable
    }))
    def resourceNameValue: String
    def filtersValue: scala.Option[List[Filter.ReadOnly]]
    def resourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceNameValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest) extends ListTagsForResourceRequest.ReadOnly {
    override def resourceNameValue: String = impl.resourceName(): String
    override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      Filter.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest): ReadOnly = new Wrapper(impl)
}