package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListTagsForResourceResponse(tagList: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse.builder().optionallyWith(tagList.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tagList).build()
  }
  def asReadOnly: ListTagsForResourceResponse.ReadOnly = ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListTagsForResourceResponse = ListTagsForResourceResponse(tagListValue.map(value => value.map { item => 
      item.editable
    }))
    def tagListValue: scala.Option[List[Tag.ReadOnly]]
    def tagList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tagList", tagListValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse) extends ListTagsForResourceResponse.ReadOnly {
    override def tagListValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tagList()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse): ReadOnly = new Wrapper(impl)
}