package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ModifyDbClusterParameterGroupRequest(dbClusterParameterGroupName: String, parameters: Iterable[Parameter]) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupRequest = {
    import ModifyDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupRequest.builder().dbClusterParameterGroupName(dbClusterParameterGroupName: java.lang.String).parameters(parameters.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).build()
  }
  def asReadOnly: ModifyDbClusterParameterGroupRequest.ReadOnly = ModifyDbClusterParameterGroupRequest.wrap(buildAwsValue())
}
object ModifyDbClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ModifyDbClusterParameterGroupRequest = ModifyDbClusterParameterGroupRequest(dbClusterParameterGroupNameValue, parametersValue.map { item => 
      item.editable
    })
    def dbClusterParameterGroupNameValue: String
    def parametersValue: List[Parameter.ReadOnly]
    def dbClusterParameterGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterParameterGroupNameValue)
    def parameters: ZIO[Any, Nothing, List[Parameter.ReadOnly]] = ZIO.succeed(parametersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupRequest) extends ModifyDbClusterParameterGroupRequest.ReadOnly {
    override def dbClusterParameterGroupNameValue: String = impl.dbClusterParameterGroupName(): String
    override def parametersValue: List[Parameter.ReadOnly] = impl.parameters().asScala.map { item => 
      Parameter.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupRequest): ReadOnly = new Wrapper(impl)
}