package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ModifyDbClusterParameterGroupResponse(dbClusterParameterGroupName: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse = {
    import ModifyDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse.builder().optionallyWith(dbClusterParameterGroupName.map(value => value: java.lang.String))(_.dbClusterParameterGroupName).build()
  }
  def asReadOnly: ModifyDbClusterParameterGroupResponse.ReadOnly = ModifyDbClusterParameterGroupResponse.wrap(buildAwsValue())
}
object ModifyDbClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ModifyDbClusterParameterGroupResponse = ModifyDbClusterParameterGroupResponse(dbClusterParameterGroupNameValue.map(value => value))
    def dbClusterParameterGroupNameValue: scala.Option[String]
    def dbClusterParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroupName", dbClusterParameterGroupNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse) extends ModifyDbClusterParameterGroupResponse.ReadOnly { override def dbClusterParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroupName()).map(value => value: String) }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse): ReadOnly = new Wrapper(impl)
}