package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ModifyDbClusterRequest(dbClusterIdentifier: String, newDBClusterIdentifier: scala.Option[String] = None, applyImmediately: scala.Option[Boolean] = None, backupRetentionPeriod: scala.Option[primitives.IntegerOptional] = None, dbClusterParameterGroupName: scala.Option[String] = None, vpcSecurityGroupIds: scala.Option[Iterable[String]] = None, port: scala.Option[primitives.IntegerOptional] = None, masterUserPassword: scala.Option[String] = None, preferredBackupWindow: scala.Option[String] = None, preferredMaintenanceWindow: scala.Option[String] = None, cloudwatchLogsExportConfiguration: scala.Option[CloudwatchLogsExportConfiguration] = None, engineVersion: scala.Option[String] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest = {
    import ModifyDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest.builder().dbClusterIdentifier(dbClusterIdentifier: java.lang.String).optionallyWith(newDBClusterIdentifier.map(value => value: java.lang.String))(_.newDBClusterIdentifier).optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(_.applyImmediately).optionallyWith(backupRetentionPeriod.map(value => value: java.lang.Integer))(_.backupRetentionPeriod).optionallyWith(dbClusterParameterGroupName.map(value => value: java.lang.String))(_.dbClusterParameterGroupName).optionallyWith(vpcSecurityGroupIds.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.vpcSecurityGroupIds).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(masterUserPassword.map(value => value: java.lang.String))(_.masterUserPassword).optionallyWith(preferredBackupWindow.map(value => value: java.lang.String))(_.preferredBackupWindow).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(cloudwatchLogsExportConfiguration.map(value => value.buildAwsValue()))(_.cloudwatchLogsExportConfiguration).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).build()
  }
  def asReadOnly: ModifyDbClusterRequest.ReadOnly = ModifyDbClusterRequest.wrap(buildAwsValue())
}
object ModifyDbClusterRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ModifyDbClusterRequest = ModifyDbClusterRequest(dbClusterIdentifierValue, newDBClusterIdentifierValue.map(value => value), applyImmediatelyValue.map(value => value), backupRetentionPeriodValue.map(value => value), dbClusterParameterGroupNameValue.map(value => value), vpcSecurityGroupIdsValue.map(value => value), portValue.map(value => value), masterUserPasswordValue.map(value => value), preferredBackupWindowValue.map(value => value), preferredMaintenanceWindowValue.map(value => value), cloudwatchLogsExportConfigurationValue.map(value => value.editable), engineVersionValue.map(value => value), deletionProtectionValue.map(value => value))
    def dbClusterIdentifierValue: String
    def newDBClusterIdentifierValue: scala.Option[String]
    def applyImmediatelyValue: scala.Option[Boolean]
    def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional]
    def dbClusterParameterGroupNameValue: scala.Option[String]
    def vpcSecurityGroupIdsValue: scala.Option[List[String]]
    def portValue: scala.Option[primitives.IntegerOptional]
    def masterUserPasswordValue: scala.Option[String]
    def preferredBackupWindowValue: scala.Option[String]
    def preferredMaintenanceWindowValue: scala.Option[String]
    def cloudwatchLogsExportConfigurationValue: scala.Option[CloudwatchLogsExportConfiguration.ReadOnly]
    def engineVersionValue: scala.Option[String]
    def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
    def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
    def newDBClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("newDBClusterIdentifier", newDBClusterIdentifierValue)
    def applyImmediately: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("applyImmediately", applyImmediatelyValue)
    def backupRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriodValue)
    def dbClusterParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroupName", dbClusterParameterGroupNameValue)
    def vpcSecurityGroupIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIdsValue)
    def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
    def masterUserPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
    def preferredBackupWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
    def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
    def cloudwatchLogsExportConfiguration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CloudwatchLogsExportConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cloudwatchLogsExportConfiguration", cloudwatchLogsExportConfigurationValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest) extends ModifyDbClusterRequest.ReadOnly {
    override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
    override def newDBClusterIdentifierValue: scala.Option[String] = scala.Option(impl.newDBClusterIdentifier()).map(value => value: String)
    override def applyImmediatelyValue: scala.Option[Boolean] = scala.Option(impl.applyImmediately()).map(value => value: Boolean)
    override def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.backupRetentionPeriod()).map(value => value: primitives.IntegerOptional)
    override def dbClusterParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroupName()).map(value => value: String)
    override def vpcSecurityGroupIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSecurityGroupIds()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def portValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.port()).map(value => value: primitives.IntegerOptional)
    override def masterUserPasswordValue: scala.Option[String] = scala.Option(impl.masterUserPassword()).map(value => value: String)
    override def preferredBackupWindowValue: scala.Option[String] = scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override def preferredMaintenanceWindowValue: scala.Option[String] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: String)
    override def cloudwatchLogsExportConfigurationValue: scala.Option[CloudwatchLogsExportConfiguration.ReadOnly] = scala.Option(impl.cloudwatchLogsExportConfiguration()).map(value => CloudwatchLogsExportConfiguration.wrap(value))
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def deletionProtectionValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deletionProtection()).map(value => value: primitives.BooleanOptional)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest): ReadOnly = new Wrapper(impl)
}