package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ModifyDbClusterResponse(dbCluster: scala.Option[DBCluster] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse = {
    import ModifyDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse.builder().optionallyWith(dbCluster.map(value => value.buildAwsValue()))(_.dbCluster).build()
  }
  def asReadOnly: ModifyDbClusterResponse.ReadOnly = ModifyDbClusterResponse.wrap(buildAwsValue())
}
object ModifyDbClusterResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ModifyDbClusterResponse = ModifyDbClusterResponse(dbClusterValue.map(value => value.editable))
    def dbClusterValue: scala.Option[DBCluster.ReadOnly]
    def dbCluster: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBCluster.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbCluster", dbClusterValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse) extends ModifyDbClusterResponse.ReadOnly { override def dbClusterValue: scala.Option[DBCluster.ReadOnly] = scala.Option(impl.dbCluster()).map(value => DBCluster.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse): ReadOnly = new Wrapper(impl)
}