package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ModifyDbClusterSnapshotAttributeRequest(dbClusterSnapshotIdentifier: String, attributeName: String, valuesToAdd: scala.Option[Iterable[String]] = None, valuesToRemove: scala.Option[Iterable[String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest = {
    import ModifyDbClusterSnapshotAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest.builder().dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: java.lang.String).attributeName(attributeName: java.lang.String).optionallyWith(valuesToAdd.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.valuesToAdd).optionallyWith(valuesToRemove.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.valuesToRemove).build()
  }
  def asReadOnly: ModifyDbClusterSnapshotAttributeRequest.ReadOnly = ModifyDbClusterSnapshotAttributeRequest.wrap(buildAwsValue())
}
object ModifyDbClusterSnapshotAttributeRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ModifyDbClusterSnapshotAttributeRequest = ModifyDbClusterSnapshotAttributeRequest(dbClusterSnapshotIdentifierValue, attributeNameValue, valuesToAddValue.map(value => value), valuesToRemoveValue.map(value => value))
    def dbClusterSnapshotIdentifierValue: String
    def attributeNameValue: String
    def valuesToAddValue: scala.Option[List[String]]
    def valuesToRemoveValue: scala.Option[List[String]]
    def dbClusterSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterSnapshotIdentifierValue)
    def attributeName: ZIO[Any, Nothing, String] = ZIO.succeed(attributeNameValue)
    def valuesToAdd: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("valuesToAdd", valuesToAddValue)
    def valuesToRemove: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("valuesToRemove", valuesToRemoveValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest) extends ModifyDbClusterSnapshotAttributeRequest.ReadOnly {
    override def dbClusterSnapshotIdentifierValue: String = impl.dbClusterSnapshotIdentifier(): String
    override def attributeNameValue: String = impl.attributeName(): String
    override def valuesToAddValue: scala.Option[List[String]] = scala.Option(impl.valuesToAdd()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def valuesToRemoveValue: scala.Option[List[String]] = scala.Option(impl.valuesToRemove()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest): ReadOnly = new Wrapper(impl)
}