package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ModifyDbInstanceRequest(dbInstanceIdentifier: String, dbInstanceClass: scala.Option[String] = None, applyImmediately: scala.Option[Boolean] = None, preferredMaintenanceWindow: scala.Option[String] = None, autoMinorVersionUpgrade: scala.Option[primitives.BooleanOptional] = None, newDBInstanceIdentifier: scala.Option[String] = None, caCertificateIdentifier: scala.Option[String] = None, promotionTier: scala.Option[primitives.IntegerOptional] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest = {
    import ModifyDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest.builder().dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String).optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(_.dbInstanceClass).optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(_.applyImmediately).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(autoMinorVersionUpgrade.map(value => value: java.lang.Boolean))(_.autoMinorVersionUpgrade).optionallyWith(newDBInstanceIdentifier.map(value => value: java.lang.String))(_.newDBInstanceIdentifier).optionallyWith(caCertificateIdentifier.map(value => value: java.lang.String))(_.caCertificateIdentifier).optionallyWith(promotionTier.map(value => value: java.lang.Integer))(_.promotionTier).build()
  }
  def asReadOnly: ModifyDbInstanceRequest.ReadOnly = ModifyDbInstanceRequest.wrap(buildAwsValue())
}
object ModifyDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ModifyDbInstanceRequest = ModifyDbInstanceRequest(dbInstanceIdentifierValue, dbInstanceClassValue.map(value => value), applyImmediatelyValue.map(value => value), preferredMaintenanceWindowValue.map(value => value), autoMinorVersionUpgradeValue.map(value => value), newDBInstanceIdentifierValue.map(value => value), caCertificateIdentifierValue.map(value => value), promotionTierValue.map(value => value))
    def dbInstanceIdentifierValue: String
    def dbInstanceClassValue: scala.Option[String]
    def applyImmediatelyValue: scala.Option[Boolean]
    def preferredMaintenanceWindowValue: scala.Option[String]
    def autoMinorVersionUpgradeValue: scala.Option[primitives.BooleanOptional]
    def newDBInstanceIdentifierValue: scala.Option[String]
    def caCertificateIdentifierValue: scala.Option[String]
    def promotionTierValue: scala.Option[primitives.IntegerOptional]
    def dbInstanceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceIdentifierValue)
    def dbInstanceClass: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClassValue)
    def applyImmediately: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("applyImmediately", applyImmediatelyValue)
    def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
    def autoMinorVersionUpgrade: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgradeValue)
    def newDBInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("newDBInstanceIdentifier", newDBInstanceIdentifierValue)
    def caCertificateIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("caCertificateIdentifier", caCertificateIdentifierValue)
    def promotionTier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("promotionTier", promotionTierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest) extends ModifyDbInstanceRequest.ReadOnly {
    override def dbInstanceIdentifierValue: String = impl.dbInstanceIdentifier(): String
    override def dbInstanceClassValue: scala.Option[String] = scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override def applyImmediatelyValue: scala.Option[Boolean] = scala.Option(impl.applyImmediately()).map(value => value: Boolean)
    override def preferredMaintenanceWindowValue: scala.Option[String] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: String)
    override def autoMinorVersionUpgradeValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.autoMinorVersionUpgrade()).map(value => value: primitives.BooleanOptional)
    override def newDBInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.newDBInstanceIdentifier()).map(value => value: String)
    override def caCertificateIdentifierValue: scala.Option[String] = scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
    override def promotionTierValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.promotionTier()).map(value => value: primitives.IntegerOptional)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest): ReadOnly = new Wrapper(impl)
}