package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ModifyDbSubnetGroupRequest(dbSubnetGroupName: String, dbSubnetGroupDescription: scala.Option[String] = None, subnetIds: Iterable[String]) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest = {
    import ModifyDbSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest.builder().dbSubnetGroupName(dbSubnetGroupName: java.lang.String).optionallyWith(dbSubnetGroupDescription.map(value => value: java.lang.String))(_.dbSubnetGroupDescription).subnetIds(subnetIds.map { item => 
      item: java.lang.String
    }.asJavaCollection).build()
  }
  def asReadOnly: ModifyDbSubnetGroupRequest.ReadOnly = ModifyDbSubnetGroupRequest.wrap(buildAwsValue())
}
object ModifyDbSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ModifyDbSubnetGroupRequest = ModifyDbSubnetGroupRequest(dbSubnetGroupNameValue, dbSubnetGroupDescriptionValue.map(value => value), subnetIdsValue)
    def dbSubnetGroupNameValue: String
    def dbSubnetGroupDescriptionValue: scala.Option[String]
    def subnetIdsValue: List[String]
    def dbSubnetGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbSubnetGroupNameValue)
    def dbSubnetGroupDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupDescription", dbSubnetGroupDescriptionValue)
    def subnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIdsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest) extends ModifyDbSubnetGroupRequest.ReadOnly {
    override def dbSubnetGroupNameValue: String = impl.dbSubnetGroupName(): String
    override def dbSubnetGroupDescriptionValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupDescription()).map(value => value: String)
    override def subnetIdsValue: List[String] = impl.subnetIds().asScala.map { item => 
      item: String
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest): ReadOnly = new Wrapper(impl)
}