package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ModifyDbSubnetGroupResponse(dbSubnetGroup: scala.Option[DBSubnetGroup] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse = {
    import ModifyDbSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse.builder().optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(_.dbSubnetGroup).build()
  }
  def asReadOnly: ModifyDbSubnetGroupResponse.ReadOnly = ModifyDbSubnetGroupResponse.wrap(buildAwsValue())
}
object ModifyDbSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ModifyDbSubnetGroupResponse = ModifyDbSubnetGroupResponse(dbSubnetGroupValue.map(value => value.editable))
    def dbSubnetGroupValue: scala.Option[DBSubnetGroup.ReadOnly]
    def dbSubnetGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBSubnetGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroupValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse) extends ModifyDbSubnetGroupResponse.ReadOnly { override def dbSubnetGroupValue: scala.Option[DBSubnetGroup.ReadOnly] = scala.Option(impl.dbSubnetGroup()).map(value => DBSubnetGroup.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse): ReadOnly = new Wrapper(impl)
}