package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ModifyEventSubscriptionRequest(subscriptionName: String, snsTopicArn: scala.Option[String] = None, sourceType: scala.Option[String] = None, eventCategories: scala.Option[Iterable[String]] = None, enabled: scala.Option[primitives.BooleanOptional] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionRequest = {
    import ModifyEventSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionRequest.builder().subscriptionName(subscriptionName: java.lang.String).optionallyWith(snsTopicArn.map(value => value: java.lang.String))(_.snsTopicArn).optionallyWith(sourceType.map(value => value: java.lang.String))(_.sourceType).optionallyWith(eventCategories.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.eventCategories).optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled).build()
  }
  def asReadOnly: ModifyEventSubscriptionRequest.ReadOnly = ModifyEventSubscriptionRequest.wrap(buildAwsValue())
}
object ModifyEventSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ModifyEventSubscriptionRequest = ModifyEventSubscriptionRequest(subscriptionNameValue, snsTopicArnValue.map(value => value), sourceTypeValue.map(value => value), eventCategoriesValue.map(value => value), enabledValue.map(value => value))
    def subscriptionNameValue: String
    def snsTopicArnValue: scala.Option[String]
    def sourceTypeValue: scala.Option[String]
    def eventCategoriesValue: scala.Option[List[String]]
    def enabledValue: scala.Option[primitives.BooleanOptional]
    def subscriptionName: ZIO[Any, Nothing, String] = ZIO.succeed(subscriptionNameValue)
    def snsTopicArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snsTopicArn", snsTopicArnValue)
    def sourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceType", sourceTypeValue)
    def eventCategories: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventCategories", eventCategoriesValue)
    def enabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enabled", enabledValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionRequest) extends ModifyEventSubscriptionRequest.ReadOnly {
    override def subscriptionNameValue: String = impl.subscriptionName(): String
    override def snsTopicArnValue: scala.Option[String] = scala.Option(impl.snsTopicArn()).map(value => value: String)
    override def sourceTypeValue: scala.Option[String] = scala.Option(impl.sourceType()).map(value => value: String)
    override def eventCategoriesValue: scala.Option[List[String]] = scala.Option(impl.eventCategories()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def enabledValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enabled()).map(value => value: primitives.BooleanOptional)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionRequest): ReadOnly = new Wrapper(impl)
}