package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ModifyGlobalClusterRequest(globalClusterIdentifier: primitives.GlobalClusterIdentifier, newGlobalClusterIdentifier: scala.Option[primitives.GlobalClusterIdentifier] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ModifyGlobalClusterRequest = {
    import ModifyGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyGlobalClusterRequest.builder().globalClusterIdentifier(globalClusterIdentifier: java.lang.String).optionallyWith(newGlobalClusterIdentifier.map(value => value: java.lang.String))(_.newGlobalClusterIdentifier).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).build()
  }
  def asReadOnly: ModifyGlobalClusterRequest.ReadOnly = ModifyGlobalClusterRequest.wrap(buildAwsValue())
}
object ModifyGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ModifyGlobalClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ModifyGlobalClusterRequest = ModifyGlobalClusterRequest(globalClusterIdentifierValue, newGlobalClusterIdentifierValue.map(value => value), deletionProtectionValue.map(value => value))
    def globalClusterIdentifierValue: primitives.GlobalClusterIdentifier
    def newGlobalClusterIdentifierValue: scala.Option[primitives.GlobalClusterIdentifier]
    def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
    def globalClusterIdentifier: ZIO[Any, Nothing, primitives.GlobalClusterIdentifier] = ZIO.succeed(globalClusterIdentifierValue)
    def newGlobalClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GlobalClusterIdentifier] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("newGlobalClusterIdentifier", newGlobalClusterIdentifierValue)
    def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ModifyGlobalClusterRequest) extends ModifyGlobalClusterRequest.ReadOnly {
    override def globalClusterIdentifierValue: primitives.GlobalClusterIdentifier = impl.globalClusterIdentifier(): primitives.GlobalClusterIdentifier
    override def newGlobalClusterIdentifierValue: scala.Option[primitives.GlobalClusterIdentifier] = scala.Option(impl.newGlobalClusterIdentifier()).map(value => value: primitives.GlobalClusterIdentifier)
    override def deletionProtectionValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deletionProtection()).map(value => value: primitives.BooleanOptional)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ModifyGlobalClusterRequest): ReadOnly = new Wrapper(impl)
}