package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class OrderableDBInstanceOption(engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, dbInstanceClass: scala.Option[String] = None, licenseModel: scala.Option[String] = None, availabilityZones: scala.Option[Iterable[AvailabilityZone]] = None, vpc: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption = {
    import OrderableDBInstanceOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption.builder().optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(_.dbInstanceClass).optionallyWith(licenseModel.map(value => value: java.lang.String))(_.licenseModel).optionallyWith(availabilityZones.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.availabilityZones).optionallyWith(vpc.map(value => value: java.lang.Boolean))(_.vpc).build()
  }
  def asReadOnly: OrderableDBInstanceOption.ReadOnly = OrderableDBInstanceOption.wrap(buildAwsValue())
}
object OrderableDBInstanceOption {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: OrderableDBInstanceOption = OrderableDBInstanceOption(engineValue.map(value => value), engineVersionValue.map(value => value), dbInstanceClassValue.map(value => value), licenseModelValue.map(value => value), availabilityZonesValue.map(value => value.map { item => 
      item.editable
    }), vpcValue.map(value => value))
    def engineValue: scala.Option[String]
    def engineVersionValue: scala.Option[String]
    def dbInstanceClassValue: scala.Option[String]
    def licenseModelValue: scala.Option[String]
    def availabilityZonesValue: scala.Option[List[AvailabilityZone.ReadOnly]]
    def vpcValue: scala.Option[Boolean]
    def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def dbInstanceClass: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClassValue)
    def licenseModel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseModel", licenseModelValue)
    def availabilityZones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AvailabilityZone.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZones", availabilityZonesValue)
    def vpc: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpc", vpcValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption) extends OrderableDBInstanceOption.ReadOnly {
    override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def dbInstanceClassValue: scala.Option[String] = scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override def licenseModelValue: scala.Option[String] = scala.Option(impl.licenseModel()).map(value => value: String)
    override def availabilityZonesValue: scala.Option[List[AvailabilityZone.ReadOnly]] = scala.Option(impl.availabilityZones()).map(value => value.asScala.map { item => 
      AvailabilityZone.wrap(item)
    }.toList)
    override def vpcValue: scala.Option[Boolean] = scala.Option(impl.vpc()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption): ReadOnly = new Wrapper(impl)
}