package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Parameter(parameterName: scala.Option[String] = None, parameterValue: scala.Option[String] = None, description: scala.Option[String] = None, source: scala.Option[String] = None, applyType: scala.Option[String] = None, dataType: scala.Option[String] = None, allowedValues: scala.Option[String] = None, isModifiable: scala.Option[Boolean] = None, minimumEngineVersion: scala.Option[String] = None, applyMethod: scala.Option[ApplyMethod] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.Parameter = {
    import Parameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.Parameter.builder().optionallyWith(parameterName.map(value => value: java.lang.String))(_.parameterName).optionallyWith(parameterValue.map(value => value: java.lang.String))(_.parameterValue).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(source.map(value => value: java.lang.String))(_.source).optionallyWith(applyType.map(value => value: java.lang.String))(_.applyType).optionallyWith(dataType.map(value => value: java.lang.String))(_.dataType).optionallyWith(allowedValues.map(value => value: java.lang.String))(_.allowedValues).optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(_.isModifiable).optionallyWith(minimumEngineVersion.map(value => value: java.lang.String))(_.minimumEngineVersion).optionallyWith(applyMethod.map(value => value.unwrap))(_.applyMethod).build()
  }
  def asReadOnly: Parameter.ReadOnly = Parameter.wrap(buildAwsValue())
}
object Parameter {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.Parameter] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Parameter = Parameter(parameterNameValue.map(value => value), parameterValueValue.map(value => value), descriptionValue.map(value => value), sourceValue.map(value => value), applyTypeValue.map(value => value), dataTypeValue.map(value => value), allowedValuesValue.map(value => value), isModifiableValue.map(value => value), minimumEngineVersionValue.map(value => value), applyMethodValue.map(value => value))
    def parameterNameValue: scala.Option[String]
    def parameterValueValue: scala.Option[String]
    def descriptionValue: scala.Option[String]
    def sourceValue: scala.Option[String]
    def applyTypeValue: scala.Option[String]
    def dataTypeValue: scala.Option[String]
    def allowedValuesValue: scala.Option[String]
    def isModifiableValue: scala.Option[Boolean]
    def minimumEngineVersionValue: scala.Option[String]
    def applyMethodValue: scala.Option[ApplyMethod]
    def parameterName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parameterName", parameterNameValue)
    def parameterValue: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parameterValue", parameterValueValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def source: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("source", sourceValue)
    def applyType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("applyType", applyTypeValue)
    def dataType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dataType", dataTypeValue)
    def allowedValues: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowedValues", allowedValuesValue)
    def isModifiable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isModifiable", isModifiableValue)
    def minimumEngineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersionValue)
    def applyMethod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ApplyMethod] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("applyMethod", applyMethodValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.Parameter) extends Parameter.ReadOnly {
    override def parameterNameValue: scala.Option[String] = scala.Option(impl.parameterName()).map(value => value: String)
    override def parameterValueValue: scala.Option[String] = scala.Option(impl.parameterValue()).map(value => value: String)
    override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
    override def sourceValue: scala.Option[String] = scala.Option(impl.source()).map(value => value: String)
    override def applyTypeValue: scala.Option[String] = scala.Option(impl.applyType()).map(value => value: String)
    override def dataTypeValue: scala.Option[String] = scala.Option(impl.dataType()).map(value => value: String)
    override def allowedValuesValue: scala.Option[String] = scala.Option(impl.allowedValues()).map(value => value: String)
    override def isModifiableValue: scala.Option[Boolean] = scala.Option(impl.isModifiable()).map(value => value: Boolean)
    override def minimumEngineVersionValue: scala.Option[String] = scala.Option(impl.minimumEngineVersion()).map(value => value: String)
    override def applyMethodValue: scala.Option[ApplyMethod] = scala.Option(impl.applyMethod()).map(value => ApplyMethod.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.Parameter): ReadOnly = new Wrapper(impl)
}