package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PendingCloudwatchLogsExports(logTypesToEnable: scala.Option[Iterable[String]] = None, logTypesToDisable: scala.Option[Iterable[String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports = {
    import PendingCloudwatchLogsExports.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports.builder().optionallyWith(logTypesToEnable.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.logTypesToEnable).optionallyWith(logTypesToDisable.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.logTypesToDisable).build()
  }
  def asReadOnly: PendingCloudwatchLogsExports.ReadOnly = PendingCloudwatchLogsExports.wrap(buildAwsValue())
}
object PendingCloudwatchLogsExports {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PendingCloudwatchLogsExports = PendingCloudwatchLogsExports(logTypesToEnableValue.map(value => value), logTypesToDisableValue.map(value => value))
    def logTypesToEnableValue: scala.Option[List[String]]
    def logTypesToDisableValue: scala.Option[List[String]]
    def logTypesToEnable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("logTypesToEnable", logTypesToEnableValue)
    def logTypesToDisable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("logTypesToDisable", logTypesToDisableValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports) extends PendingCloudwatchLogsExports.ReadOnly {
    override def logTypesToEnableValue: scala.Option[List[String]] = scala.Option(impl.logTypesToEnable()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def logTypesToDisableValue: scala.Option[List[String]] = scala.Option(impl.logTypesToDisable()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports): ReadOnly = new Wrapper(impl)
}