package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PendingMaintenanceAction(action: scala.Option[String] = None, autoAppliedAfterDate: scala.Option[primitives.TStamp] = None, forcedApplyDate: scala.Option[primitives.TStamp] = None, optInStatus: scala.Option[String] = None, currentApplyDate: scala.Option[primitives.TStamp] = None, description: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.PendingMaintenanceAction = {
    import PendingMaintenanceAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.PendingMaintenanceAction.builder().optionallyWith(action.map(value => value: java.lang.String))(_.action).optionallyWith(autoAppliedAfterDate.map(value => value: java.time.Instant))(_.autoAppliedAfterDate).optionallyWith(forcedApplyDate.map(value => value: java.time.Instant))(_.forcedApplyDate).optionallyWith(optInStatus.map(value => value: java.lang.String))(_.optInStatus).optionallyWith(currentApplyDate.map(value => value: java.time.Instant))(_.currentApplyDate).optionallyWith(description.map(value => value: java.lang.String))(_.description).build()
  }
  def asReadOnly: PendingMaintenanceAction.ReadOnly = PendingMaintenanceAction.wrap(buildAwsValue())
}
object PendingMaintenanceAction {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.PendingMaintenanceAction] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PendingMaintenanceAction = PendingMaintenanceAction(actionValue.map(value => value), autoAppliedAfterDateValue.map(value => value), forcedApplyDateValue.map(value => value), optInStatusValue.map(value => value), currentApplyDateValue.map(value => value), descriptionValue.map(value => value))
    def actionValue: scala.Option[String]
    def autoAppliedAfterDateValue: scala.Option[primitives.TStamp]
    def forcedApplyDateValue: scala.Option[primitives.TStamp]
    def optInStatusValue: scala.Option[String]
    def currentApplyDateValue: scala.Option[primitives.TStamp]
    def descriptionValue: scala.Option[String]
    def action: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("action", actionValue)
    def autoAppliedAfterDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("autoAppliedAfterDate", autoAppliedAfterDateValue)
    def forcedApplyDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("forcedApplyDate", forcedApplyDateValue)
    def optInStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optInStatus", optInStatusValue)
    def currentApplyDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currentApplyDate", currentApplyDateValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.PendingMaintenanceAction) extends PendingMaintenanceAction.ReadOnly {
    override def actionValue: scala.Option[String] = scala.Option(impl.action()).map(value => value: String)
    override def autoAppliedAfterDateValue: scala.Option[primitives.TStamp] = scala.Option(impl.autoAppliedAfterDate()).map(value => value: primitives.TStamp)
    override def forcedApplyDateValue: scala.Option[primitives.TStamp] = scala.Option(impl.forcedApplyDate()).map(value => value: primitives.TStamp)
    override def optInStatusValue: scala.Option[String] = scala.Option(impl.optInStatus()).map(value => value: String)
    override def currentApplyDateValue: scala.Option[primitives.TStamp] = scala.Option(impl.currentApplyDate()).map(value => value: primitives.TStamp)
    override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.PendingMaintenanceAction): ReadOnly = new Wrapper(impl)
}