package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PendingModifiedValues(dbInstanceClass: scala.Option[String] = None, allocatedStorage: scala.Option[primitives.IntegerOptional] = None, masterUserPassword: scala.Option[String] = None, port: scala.Option[primitives.IntegerOptional] = None, backupRetentionPeriod: scala.Option[primitives.IntegerOptional] = None, multiAZ: scala.Option[primitives.BooleanOptional] = None, engineVersion: scala.Option[String] = None, licenseModel: scala.Option[String] = None, iops: scala.Option[primitives.IntegerOptional] = None, dbInstanceIdentifier: scala.Option[String] = None, storageType: scala.Option[String] = None, caCertificateIdentifier: scala.Option[String] = None, dbSubnetGroupName: scala.Option[String] = None, pendingCloudwatchLogsExports: scala.Option[PendingCloudwatchLogsExports] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.PendingModifiedValues = {
    import PendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.PendingModifiedValues.builder().optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(_.dbInstanceClass).optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(_.allocatedStorage).optionallyWith(masterUserPassword.map(value => value: java.lang.String))(_.masterUserPassword).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(backupRetentionPeriod.map(value => value: java.lang.Integer))(_.backupRetentionPeriod).optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(licenseModel.map(value => value: java.lang.String))(_.licenseModel).optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops).optionallyWith(dbInstanceIdentifier.map(value => value: java.lang.String))(_.dbInstanceIdentifier).optionallyWith(storageType.map(value => value: java.lang.String))(_.storageType).optionallyWith(caCertificateIdentifier.map(value => value: java.lang.String))(_.caCertificateIdentifier).optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(_.dbSubnetGroupName).optionallyWith(pendingCloudwatchLogsExports.map(value => value.buildAwsValue()))(_.pendingCloudwatchLogsExports).build()
  }
  def asReadOnly: PendingModifiedValues.ReadOnly = PendingModifiedValues.wrap(buildAwsValue())
}
object PendingModifiedValues {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.PendingModifiedValues] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PendingModifiedValues = PendingModifiedValues(dbInstanceClassValue.map(value => value), allocatedStorageValue.map(value => value), masterUserPasswordValue.map(value => value), portValue.map(value => value), backupRetentionPeriodValue.map(value => value), multiAZValue.map(value => value), engineVersionValue.map(value => value), licenseModelValue.map(value => value), iopsValue.map(value => value), dbInstanceIdentifierValue.map(value => value), storageTypeValue.map(value => value), caCertificateIdentifierValue.map(value => value), dbSubnetGroupNameValue.map(value => value), pendingCloudwatchLogsExportsValue.map(value => value.editable))
    def dbInstanceClassValue: scala.Option[String]
    def allocatedStorageValue: scala.Option[primitives.IntegerOptional]
    def masterUserPasswordValue: scala.Option[String]
    def portValue: scala.Option[primitives.IntegerOptional]
    def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional]
    def multiAZValue: scala.Option[primitives.BooleanOptional]
    def engineVersionValue: scala.Option[String]
    def licenseModelValue: scala.Option[String]
    def iopsValue: scala.Option[primitives.IntegerOptional]
    def dbInstanceIdentifierValue: scala.Option[String]
    def storageTypeValue: scala.Option[String]
    def caCertificateIdentifierValue: scala.Option[String]
    def dbSubnetGroupNameValue: scala.Option[String]
    def pendingCloudwatchLogsExportsValue: scala.Option[PendingCloudwatchLogsExports.ReadOnly]
    def dbInstanceClass: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClassValue)
    def allocatedStorage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allocatedStorage", allocatedStorageValue)
    def masterUserPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
    def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
    def backupRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriodValue)
    def multiAZ: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("multiAZ", multiAZValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def licenseModel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseModel", licenseModelValue)
    def iops: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iops", iopsValue)
    def dbInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifierValue)
    def storageType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageType", storageTypeValue)
    def caCertificateIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("caCertificateIdentifier", caCertificateIdentifierValue)
    def dbSubnetGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupNameValue)
    def pendingCloudwatchLogsExports: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PendingCloudwatchLogsExports.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pendingCloudwatchLogsExports", pendingCloudwatchLogsExportsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.PendingModifiedValues) extends PendingModifiedValues.ReadOnly {
    override def dbInstanceClassValue: scala.Option[String] = scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override def allocatedStorageValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.allocatedStorage()).map(value => value: primitives.IntegerOptional)
    override def masterUserPasswordValue: scala.Option[String] = scala.Option(impl.masterUserPassword()).map(value => value: String)
    override def portValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.port()).map(value => value: primitives.IntegerOptional)
    override def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.backupRetentionPeriod()).map(value => value: primitives.IntegerOptional)
    override def multiAZValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.multiAZ()).map(value => value: primitives.BooleanOptional)
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def licenseModelValue: scala.Option[String] = scala.Option(impl.licenseModel()).map(value => value: String)
    override def iopsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.iops()).map(value => value: primitives.IntegerOptional)
    override def dbInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override def storageTypeValue: scala.Option[String] = scala.Option(impl.storageType()).map(value => value: String)
    override def caCertificateIdentifierValue: scala.Option[String] = scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
    override def dbSubnetGroupNameValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override def pendingCloudwatchLogsExportsValue: scala.Option[PendingCloudwatchLogsExports.ReadOnly] = scala.Option(impl.pendingCloudwatchLogsExports()).map(value => PendingCloudwatchLogsExports.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.PendingModifiedValues): ReadOnly = new Wrapper(impl)
}