package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RebootDbInstanceRequest(dbInstanceIdentifier: String, forceFailover: scala.Option[primitives.BooleanOptional] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.RebootDbInstanceRequest = {
    import RebootDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RebootDbInstanceRequest.builder().dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String).optionallyWith(forceFailover.map(value => value: java.lang.Boolean))(_.forceFailover).build()
  }
  def asReadOnly: RebootDbInstanceRequest.ReadOnly = RebootDbInstanceRequest.wrap(buildAwsValue())
}
object RebootDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.RebootDbInstanceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RebootDbInstanceRequest = RebootDbInstanceRequest(dbInstanceIdentifierValue, forceFailoverValue.map(value => value))
    def dbInstanceIdentifierValue: String
    def forceFailoverValue: scala.Option[primitives.BooleanOptional]
    def dbInstanceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceIdentifierValue)
    def forceFailover: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("forceFailover", forceFailoverValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.RebootDbInstanceRequest) extends RebootDbInstanceRequest.ReadOnly {
    override def dbInstanceIdentifierValue: String = impl.dbInstanceIdentifier(): String
    override def forceFailoverValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.forceFailover()).map(value => value: primitives.BooleanOptional)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.RebootDbInstanceRequest): ReadOnly = new Wrapper(impl)
}