package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RebootDbInstanceResponse(dbInstance: scala.Option[DBInstance] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse = {
    import RebootDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse.builder().optionallyWith(dbInstance.map(value => value.buildAwsValue()))(_.dbInstance).build()
  }
  def asReadOnly: RebootDbInstanceResponse.ReadOnly = RebootDbInstanceResponse.wrap(buildAwsValue())
}
object RebootDbInstanceResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RebootDbInstanceResponse = RebootDbInstanceResponse(dbInstanceValue.map(value => value.editable))
    def dbInstanceValue: scala.Option[DBInstance.ReadOnly]
    def dbInstance: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBInstance.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstance", dbInstanceValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse) extends RebootDbInstanceResponse.ReadOnly { override def dbInstanceValue: scala.Option[DBInstance.ReadOnly] = scala.Option(impl.dbInstance()).map(value => DBInstance.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse): ReadOnly = new Wrapper(impl)
}