package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RemoveFromGlobalClusterRequest(globalClusterIdentifier: primitives.GlobalClusterIdentifier, dbClusterIdentifier: String) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.RemoveFromGlobalClusterRequest = {
    import RemoveFromGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RemoveFromGlobalClusterRequest.builder().globalClusterIdentifier(globalClusterIdentifier: java.lang.String).dbClusterIdentifier(dbClusterIdentifier: java.lang.String).build()
  }
  def asReadOnly: RemoveFromGlobalClusterRequest.ReadOnly = RemoveFromGlobalClusterRequest.wrap(buildAwsValue())
}
object RemoveFromGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.RemoveFromGlobalClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RemoveFromGlobalClusterRequest = RemoveFromGlobalClusterRequest(globalClusterIdentifierValue, dbClusterIdentifierValue)
    def globalClusterIdentifierValue: primitives.GlobalClusterIdentifier
    def dbClusterIdentifierValue: String
    def globalClusterIdentifier: ZIO[Any, Nothing, primitives.GlobalClusterIdentifier] = ZIO.succeed(globalClusterIdentifierValue)
    def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.RemoveFromGlobalClusterRequest) extends RemoveFromGlobalClusterRequest.ReadOnly {
    override def globalClusterIdentifierValue: primitives.GlobalClusterIdentifier = impl.globalClusterIdentifier(): primitives.GlobalClusterIdentifier
    override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.RemoveFromGlobalClusterRequest): ReadOnly = new Wrapper(impl)
}