package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RemoveSourceIdentifierFromSubscriptionRequest(subscriptionName: String, sourceIdentifier: String) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.RemoveSourceIdentifierFromSubscriptionRequest = {
    import RemoveSourceIdentifierFromSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RemoveSourceIdentifierFromSubscriptionRequest.builder().subscriptionName(subscriptionName: java.lang.String).sourceIdentifier(sourceIdentifier: java.lang.String).build()
  }
  def asReadOnly: RemoveSourceIdentifierFromSubscriptionRequest.ReadOnly = RemoveSourceIdentifierFromSubscriptionRequest.wrap(buildAwsValue())
}
object RemoveSourceIdentifierFromSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.RemoveSourceIdentifierFromSubscriptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RemoveSourceIdentifierFromSubscriptionRequest = RemoveSourceIdentifierFromSubscriptionRequest(subscriptionNameValue, sourceIdentifierValue)
    def subscriptionNameValue: String
    def sourceIdentifierValue: String
    def subscriptionName: ZIO[Any, Nothing, String] = ZIO.succeed(subscriptionNameValue)
    def sourceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(sourceIdentifierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.RemoveSourceIdentifierFromSubscriptionRequest) extends RemoveSourceIdentifierFromSubscriptionRequest.ReadOnly {
    override def subscriptionNameValue: String = impl.subscriptionName(): String
    override def sourceIdentifierValue: String = impl.sourceIdentifier(): String
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.RemoveSourceIdentifierFromSubscriptionRequest): ReadOnly = new Wrapper(impl)
}