package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RemoveTagsFromResourceRequest(resourceName: String, tagKeys: Iterable[String]) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest = {
    import RemoveTagsFromResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest.builder().resourceName(resourceName: java.lang.String).tagKeys(tagKeys.map { item => 
      item: java.lang.String
    }.asJavaCollection).build()
  }
  def asReadOnly: RemoveTagsFromResourceRequest.ReadOnly = RemoveTagsFromResourceRequest.wrap(buildAwsValue())
}
object RemoveTagsFromResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RemoveTagsFromResourceRequest = RemoveTagsFromResourceRequest(resourceNameValue, tagKeysValue)
    def resourceNameValue: String
    def tagKeysValue: List[String]
    def resourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceNameValue)
    def tagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeysValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest) extends RemoveTagsFromResourceRequest.ReadOnly {
    override def resourceNameValue: String = impl.resourceName(): String
    override def tagKeysValue: List[String] = impl.tagKeys().asScala.map { item => 
      item: String
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest): ReadOnly = new Wrapper(impl)
}