package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ResetDbClusterParameterGroupRequest(dbClusterParameterGroupName: String, resetAllParameters: scala.Option[Boolean] = None, parameters: scala.Option[Iterable[Parameter]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest = {
    import ResetDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest.builder().dbClusterParameterGroupName(dbClusterParameterGroupName: java.lang.String).optionallyWith(resetAllParameters.map(value => value: java.lang.Boolean))(_.resetAllParameters).optionallyWith(parameters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.parameters).build()
  }
  def asReadOnly: ResetDbClusterParameterGroupRequest.ReadOnly = ResetDbClusterParameterGroupRequest.wrap(buildAwsValue())
}
object ResetDbClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ResetDbClusterParameterGroupRequest = ResetDbClusterParameterGroupRequest(dbClusterParameterGroupNameValue, resetAllParametersValue.map(value => value), parametersValue.map(value => value.map { item => 
      item.editable
    }))
    def dbClusterParameterGroupNameValue: String
    def resetAllParametersValue: scala.Option[Boolean]
    def parametersValue: scala.Option[List[Parameter.ReadOnly]]
    def dbClusterParameterGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterParameterGroupNameValue)
    def resetAllParameters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resetAllParameters", resetAllParametersValue)
    def parameters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Parameter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parameters", parametersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest) extends ResetDbClusterParameterGroupRequest.ReadOnly {
    override def dbClusterParameterGroupNameValue: String = impl.dbClusterParameterGroupName(): String
    override def resetAllParametersValue: scala.Option[Boolean] = scala.Option(impl.resetAllParameters()).map(value => value: Boolean)
    override def parametersValue: scala.Option[List[Parameter.ReadOnly]] = scala.Option(impl.parameters()).map(value => value.asScala.map { item => 
      Parameter.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest): ReadOnly = new Wrapper(impl)
}