package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ResetDbClusterParameterGroupResponse(dbClusterParameterGroupName: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse = {
    import ResetDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse.builder().optionallyWith(dbClusterParameterGroupName.map(value => value: java.lang.String))(_.dbClusterParameterGroupName).build()
  }
  def asReadOnly: ResetDbClusterParameterGroupResponse.ReadOnly = ResetDbClusterParameterGroupResponse.wrap(buildAwsValue())
}
object ResetDbClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ResetDbClusterParameterGroupResponse = ResetDbClusterParameterGroupResponse(dbClusterParameterGroupNameValue.map(value => value))
    def dbClusterParameterGroupNameValue: scala.Option[String]
    def dbClusterParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroupName", dbClusterParameterGroupNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse) extends ResetDbClusterParameterGroupResponse.ReadOnly { override def dbClusterParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroupName()).map(value => value: String) }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse): ReadOnly = new Wrapper(impl)
}