package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ResourcePendingMaintenanceActions(resourceIdentifier: scala.Option[String] = None, pendingMaintenanceActionDetails: scala.Option[Iterable[PendingMaintenanceAction]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ResourcePendingMaintenanceActions = {
    import ResourcePendingMaintenanceActions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ResourcePendingMaintenanceActions.builder().optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(_.resourceIdentifier).optionallyWith(pendingMaintenanceActionDetails.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.pendingMaintenanceActionDetails).build()
  }
  def asReadOnly: ResourcePendingMaintenanceActions.ReadOnly = ResourcePendingMaintenanceActions.wrap(buildAwsValue())
}
object ResourcePendingMaintenanceActions {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ResourcePendingMaintenanceActions] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ResourcePendingMaintenanceActions = ResourcePendingMaintenanceActions(resourceIdentifierValue.map(value => value), pendingMaintenanceActionDetailsValue.map(value => value.map { item => 
      item.editable
    }))
    def resourceIdentifierValue: scala.Option[String]
    def pendingMaintenanceActionDetailsValue: scala.Option[List[PendingMaintenanceAction.ReadOnly]]
    def resourceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifierValue)
    def pendingMaintenanceActionDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[PendingMaintenanceAction.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pendingMaintenanceActionDetails", pendingMaintenanceActionDetailsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ResourcePendingMaintenanceActions) extends ResourcePendingMaintenanceActions.ReadOnly {
    override def resourceIdentifierValue: scala.Option[String] = scala.Option(impl.resourceIdentifier()).map(value => value: String)
    override def pendingMaintenanceActionDetailsValue: scala.Option[List[PendingMaintenanceAction.ReadOnly]] = scala.Option(impl.pendingMaintenanceActionDetails()).map(value => value.asScala.map { item => 
      PendingMaintenanceAction.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ResourcePendingMaintenanceActions): ReadOnly = new Wrapper(impl)
}