package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RestoreDbClusterToPointInTimeRequest(dbClusterIdentifier: String, sourceDBClusterIdentifier: String, restoreToTime: scala.Option[primitives.TStamp] = None, useLatestRestorableTime: scala.Option[Boolean] = None, port: scala.Option[primitives.IntegerOptional] = None, dbSubnetGroupName: scala.Option[String] = None, vpcSecurityGroupIds: scala.Option[Iterable[String]] = None, tags: scala.Option[Iterable[Tag]] = None, kmsKeyId: scala.Option[String] = None, enableCloudwatchLogsExports: scala.Option[Iterable[String]] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest = {
    import RestoreDbClusterToPointInTimeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest.builder().dbClusterIdentifier(dbClusterIdentifier: java.lang.String).sourceDBClusterIdentifier(sourceDBClusterIdentifier: java.lang.String).optionallyWith(restoreToTime.map(value => value: java.time.Instant))(_.restoreToTime).optionallyWith(useLatestRestorableTime.map(value => value: java.lang.Boolean))(_.useLatestRestorableTime).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(_.dbSubnetGroupName).optionallyWith(vpcSecurityGroupIds.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.vpcSecurityGroupIds).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(enableCloudwatchLogsExports.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.enableCloudwatchLogsExports).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).build()
  }
  def asReadOnly: RestoreDbClusterToPointInTimeRequest.ReadOnly = RestoreDbClusterToPointInTimeRequest.wrap(buildAwsValue())
}
object RestoreDbClusterToPointInTimeRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RestoreDbClusterToPointInTimeRequest = RestoreDbClusterToPointInTimeRequest(dbClusterIdentifierValue, sourceDBClusterIdentifierValue, restoreToTimeValue.map(value => value), useLatestRestorableTimeValue.map(value => value), portValue.map(value => value), dbSubnetGroupNameValue.map(value => value), vpcSecurityGroupIdsValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), kmsKeyIdValue.map(value => value), enableCloudwatchLogsExportsValue.map(value => value), deletionProtectionValue.map(value => value))
    def dbClusterIdentifierValue: String
    def sourceDBClusterIdentifierValue: String
    def restoreToTimeValue: scala.Option[primitives.TStamp]
    def useLatestRestorableTimeValue: scala.Option[Boolean]
    def portValue: scala.Option[primitives.IntegerOptional]
    def dbSubnetGroupNameValue: scala.Option[String]
    def vpcSecurityGroupIdsValue: scala.Option[List[String]]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def kmsKeyIdValue: scala.Option[String]
    def enableCloudwatchLogsExportsValue: scala.Option[List[String]]
    def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
    def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
    def sourceDBClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(sourceDBClusterIdentifierValue)
    def restoreToTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("restoreToTime", restoreToTimeValue)
    def useLatestRestorableTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("useLatestRestorableTime", useLatestRestorableTimeValue)
    def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
    def dbSubnetGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupNameValue)
    def vpcSecurityGroupIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIdsValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
    def enableCloudwatchLogsExports: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableCloudwatchLogsExports", enableCloudwatchLogsExportsValue)
    def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest) extends RestoreDbClusterToPointInTimeRequest.ReadOnly {
    override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
    override def sourceDBClusterIdentifierValue: String = impl.sourceDBClusterIdentifier(): String
    override def restoreToTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.restoreToTime()).map(value => value: primitives.TStamp)
    override def useLatestRestorableTimeValue: scala.Option[Boolean] = scala.Option(impl.useLatestRestorableTime()).map(value => value: Boolean)
    override def portValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.port()).map(value => value: primitives.IntegerOptional)
    override def dbSubnetGroupNameValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override def vpcSecurityGroupIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSecurityGroupIds()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
    override def enableCloudwatchLogsExportsValue: scala.Option[List[String]] = scala.Option(impl.enableCloudwatchLogsExports()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def deletionProtectionValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deletionProtection()).map(value => value: primitives.BooleanOptional)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest): ReadOnly = new Wrapper(impl)
}