package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RestoreDbClusterToPointInTimeResponse(dbCluster: scala.Option[DBCluster] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse = {
    import RestoreDbClusterToPointInTimeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse.builder().optionallyWith(dbCluster.map(value => value.buildAwsValue()))(_.dbCluster).build()
  }
  def asReadOnly: RestoreDbClusterToPointInTimeResponse.ReadOnly = RestoreDbClusterToPointInTimeResponse.wrap(buildAwsValue())
}
object RestoreDbClusterToPointInTimeResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RestoreDbClusterToPointInTimeResponse = RestoreDbClusterToPointInTimeResponse(dbClusterValue.map(value => value.editable))
    def dbClusterValue: scala.Option[DBCluster.ReadOnly]
    def dbCluster: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBCluster.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbCluster", dbClusterValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse) extends RestoreDbClusterToPointInTimeResponse.ReadOnly { override def dbClusterValue: scala.Option[DBCluster.ReadOnly] = scala.Option(impl.dbCluster()).map(value => DBCluster.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse): ReadOnly = new Wrapper(impl)
}