package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait SourceType { def unwrap: software.amazon.awssdk.services.docdb.model.SourceType }
object SourceType {
  def wrap(value: software.amazon.awssdk.services.docdb.model.SourceType): SourceType = value match {
    case software.amazon.awssdk.services.docdb.model.SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.docdb.model.SourceType.DB_INSTANCE =>
      val r = `db-instance`
      r
    case software.amazon.awssdk.services.docdb.model.SourceType.DB_PARAMETER_GROUP =>
      val r = `db-parameter-group`
      r
    case software.amazon.awssdk.services.docdb.model.SourceType.DB_SECURITY_GROUP =>
      val r = `db-security-group`
      r
    case software.amazon.awssdk.services.docdb.model.SourceType.DB_SNAPSHOT =>
      val r = `db-snapshot`
      r
    case software.amazon.awssdk.services.docdb.model.SourceType.DB_CLUSTER =>
      val r = `db-cluster`
      r
    case software.amazon.awssdk.services.docdb.model.SourceType.DB_CLUSTER_SNAPSHOT =>
      val r = `db-cluster-snapshot`
      r
  }
  case object unknownToSdkVersion extends SourceType { override def unwrap: software.amazon.awssdk.services.docdb.model.SourceType = software.amazon.awssdk.services.docdb.model.SourceType.UNKNOWN_TO_SDK_VERSION }
  case object `db-instance` extends SourceType { override def unwrap: software.amazon.awssdk.services.docdb.model.SourceType = software.amazon.awssdk.services.docdb.model.SourceType.DB_INSTANCE }
  case object `db-parameter-group` extends SourceType { override def unwrap: software.amazon.awssdk.services.docdb.model.SourceType = software.amazon.awssdk.services.docdb.model.SourceType.DB_PARAMETER_GROUP }
  case object `db-security-group` extends SourceType { override def unwrap: software.amazon.awssdk.services.docdb.model.SourceType = software.amazon.awssdk.services.docdb.model.SourceType.DB_SECURITY_GROUP }
  case object `db-snapshot` extends SourceType { override def unwrap: software.amazon.awssdk.services.docdb.model.SourceType = software.amazon.awssdk.services.docdb.model.SourceType.DB_SNAPSHOT }
  case object `db-cluster` extends SourceType { override def unwrap: software.amazon.awssdk.services.docdb.model.SourceType = software.amazon.awssdk.services.docdb.model.SourceType.DB_CLUSTER }
  case object `db-cluster-snapshot` extends SourceType { override def unwrap: software.amazon.awssdk.services.docdb.model.SourceType = software.amazon.awssdk.services.docdb.model.SourceType.DB_CLUSTER_SNAPSHOT }
}