package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class StartDbClusterRequest(dbClusterIdentifier: String) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.StartDbClusterRequest = {
    import StartDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.StartDbClusterRequest.builder().dbClusterIdentifier(dbClusterIdentifier: java.lang.String).build()
  }
  def asReadOnly: StartDbClusterRequest.ReadOnly = StartDbClusterRequest.wrap(buildAwsValue())
}
object StartDbClusterRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.StartDbClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: StartDbClusterRequest = StartDbClusterRequest(dbClusterIdentifierValue)
    def dbClusterIdentifierValue: String
    def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.StartDbClusterRequest) extends StartDbClusterRequest.ReadOnly { override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.StartDbClusterRequest): ReadOnly = new Wrapper(impl)
}