package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class StopDbClusterRequest(dbClusterIdentifier: String) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.StopDbClusterRequest = {
    import StopDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.StopDbClusterRequest.builder().dbClusterIdentifier(dbClusterIdentifier: java.lang.String).build()
  }
  def asReadOnly: StopDbClusterRequest.ReadOnly = StopDbClusterRequest.wrap(buildAwsValue())
}
object StopDbClusterRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.StopDbClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: StopDbClusterRequest = StopDbClusterRequest(dbClusterIdentifierValue)
    def dbClusterIdentifierValue: String
    def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.StopDbClusterRequest) extends StopDbClusterRequest.ReadOnly { override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.StopDbClusterRequest): ReadOnly = new Wrapper(impl)
}