package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class StopDbClusterResponse(dbCluster: scala.Option[DBCluster] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.StopDbClusterResponse = {
    import StopDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.StopDbClusterResponse.builder().optionallyWith(dbCluster.map(value => value.buildAwsValue()))(_.dbCluster).build()
  }
  def asReadOnly: StopDbClusterResponse.ReadOnly = StopDbClusterResponse.wrap(buildAwsValue())
}
object StopDbClusterResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.StopDbClusterResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: StopDbClusterResponse = StopDbClusterResponse(dbClusterValue.map(value => value.editable))
    def dbClusterValue: scala.Option[DBCluster.ReadOnly]
    def dbCluster: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBCluster.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbCluster", dbClusterValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.StopDbClusterResponse) extends StopDbClusterResponse.ReadOnly { override def dbClusterValue: scala.Option[DBCluster.ReadOnly] = scala.Option(impl.dbCluster()).map(value => DBCluster.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.StopDbClusterResponse): ReadOnly = new Wrapper(impl)
}