package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Subnet(subnetIdentifier: scala.Option[String] = None, subnetAvailabilityZone: scala.Option[AvailabilityZone] = None, subnetStatus: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.Subnet = {
    import Subnet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.Subnet.builder().optionallyWith(subnetIdentifier.map(value => value: java.lang.String))(_.subnetIdentifier).optionallyWith(subnetAvailabilityZone.map(value => value.buildAwsValue()))(_.subnetAvailabilityZone).optionallyWith(subnetStatus.map(value => value: java.lang.String))(_.subnetStatus).build()
  }
  def asReadOnly: Subnet.ReadOnly = Subnet.wrap(buildAwsValue())
}
object Subnet {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.Subnet] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Subnet = Subnet(subnetIdentifierValue.map(value => value), subnetAvailabilityZoneValue.map(value => value.editable), subnetStatusValue.map(value => value))
    def subnetIdentifierValue: scala.Option[String]
    def subnetAvailabilityZoneValue: scala.Option[AvailabilityZone.ReadOnly]
    def subnetStatusValue: scala.Option[String]
    def subnetIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subnetIdentifier", subnetIdentifierValue)
    def subnetAvailabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AvailabilityZone.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subnetAvailabilityZone", subnetAvailabilityZoneValue)
    def subnetStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subnetStatus", subnetStatusValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.Subnet) extends Subnet.ReadOnly {
    override def subnetIdentifierValue: scala.Option[String] = scala.Option(impl.subnetIdentifier()).map(value => value: String)
    override def subnetAvailabilityZoneValue: scala.Option[AvailabilityZone.ReadOnly] = scala.Option(impl.subnetAvailabilityZone()).map(value => AvailabilityZone.wrap(value))
    override def subnetStatusValue: scala.Option[String] = scala.Option(impl.subnetStatus()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.Subnet): ReadOnly = new Wrapper(impl)
}