package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Tag(key: scala.Option[String] = None, value: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.Tag.builder().optionallyWith(key.map(value => value: java.lang.String))(_.key).optionallyWith(value.map(value => value: java.lang.String))(_.value).build()
  }
  def asReadOnly: Tag.ReadOnly = Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.Tag] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Tag = Tag(keyValue.map(value => value), valueValue.map(value => value))
    def keyValue: scala.Option[String]
    def valueValue: scala.Option[String]
    def key: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("key", keyValue)
    def value: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.Tag) extends Tag.ReadOnly {
    override def keyValue: scala.Option[String] = scala.Option(impl.key()).map(value => value: String)
    override def valueValue: scala.Option[String] = scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.Tag): ReadOnly = new Wrapper(impl)
}