package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpgradeTarget(engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, description: scala.Option[String] = None, autoUpgrade: scala.Option[Boolean] = None, isMajorVersionUpgrade: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.UpgradeTarget = {
    import UpgradeTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.UpgradeTarget.builder().optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(autoUpgrade.map(value => value: java.lang.Boolean))(_.autoUpgrade).optionallyWith(isMajorVersionUpgrade.map(value => value: java.lang.Boolean))(_.isMajorVersionUpgrade).build()
  }
  def asReadOnly: UpgradeTarget.ReadOnly = UpgradeTarget.wrap(buildAwsValue())
}
object UpgradeTarget {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.UpgradeTarget] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpgradeTarget = UpgradeTarget(engineValue.map(value => value), engineVersionValue.map(value => value), descriptionValue.map(value => value), autoUpgradeValue.map(value => value), isMajorVersionUpgradeValue.map(value => value))
    def engineValue: scala.Option[String]
    def engineVersionValue: scala.Option[String]
    def descriptionValue: scala.Option[String]
    def autoUpgradeValue: scala.Option[Boolean]
    def isMajorVersionUpgradeValue: scala.Option[Boolean]
    def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def autoUpgrade: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("autoUpgrade", autoUpgradeValue)
    def isMajorVersionUpgrade: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isMajorVersionUpgrade", isMajorVersionUpgradeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.UpgradeTarget) extends UpgradeTarget.ReadOnly {
    override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
    override def autoUpgradeValue: scala.Option[Boolean] = scala.Option(impl.autoUpgrade()).map(value => value: Boolean)
    override def isMajorVersionUpgradeValue: scala.Option[Boolean] = scala.Option(impl.isMajorVersionUpgrade()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.UpgradeTarget): ReadOnly = new Wrapper(impl)
}