package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class VpcSecurityGroupMembership(vpcSecurityGroupId: scala.Option[String] = None, status: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.VpcSecurityGroupMembership = {
    import VpcSecurityGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.VpcSecurityGroupMembership.builder().optionallyWith(vpcSecurityGroupId.map(value => value: java.lang.String))(_.vpcSecurityGroupId).optionallyWith(status.map(value => value: java.lang.String))(_.status).build()
  }
  def asReadOnly: VpcSecurityGroupMembership.ReadOnly = VpcSecurityGroupMembership.wrap(buildAwsValue())
}
object VpcSecurityGroupMembership {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.VpcSecurityGroupMembership] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: VpcSecurityGroupMembership = VpcSecurityGroupMembership(vpcSecurityGroupIdValue.map(value => value), statusValue.map(value => value))
    def vpcSecurityGroupIdValue: scala.Option[String]
    def statusValue: scala.Option[String]
    def vpcSecurityGroupId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroupId", vpcSecurityGroupIdValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.VpcSecurityGroupMembership) extends VpcSecurityGroupMembership.ReadOnly {
    override def vpcSecurityGroupIdValue: scala.Option[String] = scala.Option(impl.vpcSecurityGroupId()).map(value => value: String)
    override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.VpcSecurityGroupMembership): ReadOnly = new Wrapper(impl)
}