package io.github.vigoo.zioaws.docdb
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
package object model {
  object primitives {
    type BooleanOptional = Boolean
    type GlobalClusterIdentifier = String
    type Integer = Int
    type IntegerOptional = Int
    type TStamp = Instant
  }
  type AttributeValueList = List[String]
  type AvailabilityZoneList = List[AvailabilityZone]
  type AvailabilityZones = List[String]
  type CertificateList = List[Certificate]
  type DBClusterList = List[DBCluster]
  type DBClusterMemberList = List[DBClusterMember]
  type DBClusterParameterGroupList = List[DBClusterParameterGroup]
  type DBClusterRoles = List[DBClusterRole]
  type DBClusterSnapshotAttributeList = List[DBClusterSnapshotAttribute]
  type DBClusterSnapshotList = List[DBClusterSnapshot]
  type DBEngineVersionList = List[DBEngineVersion]
  type DBInstanceList = List[DBInstance]
  type DBInstanceStatusInfoList = List[DBInstanceStatusInfo]
  type DBSubnetGroups = List[DBSubnetGroup]
  type EventCategoriesList = List[String]
  type EventCategoriesMapList = List[EventCategoriesMap]
  type EventList = List[Event]
  type EventSubscriptionsList = List[EventSubscription]
  type FilterList = List[Filter]
  type FilterValueList = List[String]
  type GlobalClusterList = List[GlobalCluster]
  type GlobalClusterMemberList = List[GlobalClusterMember]
  type KeyList = List[String]
  type LogTypeList = List[String]
  type OrderableDBInstanceOptionsList = List[OrderableDBInstanceOption]
  type ParametersList = List[Parameter]
  type PendingMaintenanceActionDetails = List[PendingMaintenanceAction]
  type PendingMaintenanceActions = List[ResourcePendingMaintenanceActions]
  type ReadReplicaIdentifierList = List[String]
  type ReadersArnList = List[String]
  type SourceIdsList = List[String]
  type SubnetIdentifierList = List[String]
  type SubnetList = List[Subnet]
  type TagList = List[Tag]
  type ValidUpgradeTargetList = List[UpgradeTarget]
  type VpcSecurityGroupIdList = List[String]
  type VpcSecurityGroupMembershipList = List[VpcSecurityGroupMembership]
}